﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
//#include "gameFunctions/getPathValue.as"
//#include "gameProgram/parseVariablePaths.as"
#include "gameFunctions/nestedEval.as"
	// evalPath
	// resolveContainer
	// getImpliedValue

// run()
define_while = function( thisCommand_obj ){
	
	
	var prom = VOW.make();
	
	if( _this.scriptInterruptCheck() )
	{// if:  script has not been interrupted
		var conditionResult = getConditionResult( thisCommand_obj );
		var condition = thisCommand_obj.data.condition;
		if(TRACE_SCRIPT)
			trace("while: "+condition[0]+" "+condition[1]+" "+condition[2]+"  result: "+conditionResult);
		if( _this._name.length == 0 )
		{// if:  This movieClip is being removed
			// clear all of this sprite's timeouts
			for (var s in _this.scripts)											// for: each script
				if(_this.scripts[s].timeoutID!=undefined)				// if:  this script has a timeout ID stored
					clearTimeout( _this.scripts[s].timeoutID );		// clear the timeout
			thisCommand_obj = null;		// stop the entire script
			conditionResult = true;		// stop the loop, without resuming the script
		}// if:  This movieClip is being removed
		
		if(conditionResult == true)
		{// if:  condition is true  &  there are commands inside the "while" statement
			// detect when inner script finishes and run everything again
			thisCommand_obj.script.done = function(){
				var waitId = setTimeout( function(){
					var inner_prom = define_while( thisCommand_obj );
					
					// unload  =>  abort all recursive promises
					var react_to_unload = react.once().to("unload");
					inner_prom.then = react_to_unload.then = function(){
						if( inner_prom.getStatus() === "pending" )		inner_prom.doBreak();
						react_to_unload.disable();
					};// unload()
					
					// this is a recursively stacking promise. If the "while" command calls itself 10 times, then there will be 10 promises waiting for each other in sequence.  Newer inner promises resolve, and resolve, until finally the oldest promise resolves and the script resumes
					inner_prom.then = prom.keep;
					// Having any setTimeout delay (even 0) will avoid a recursive call-stack, so there's no risk of a loop-panic
				}, 1 );
				thisCommand_obj.storeTimeout( waitId );
			}// done()
			
			var hasCommands = (thisCommand_obj.script.length>0);
			var hasNonComments = false;
			for( var c=0; c<thisCommand_obj.script.length; c++){
				var innerType = thisCommand_obj.script[c].command_obj.data.type;
				if( innerType !== "comment"  &&  innerType !== undefined )
				{// if:  this command is valid, and not a comment  ( AKA: It actually does something )
					hasNonComments = true;
					break;		//  stop searching for valid non-comment commands
				}// if:  this command is valid, and not a comment  ( AKA: It actually does something )
			} // for:  each command within this loop
			
			if( hasCommands  &&  hasNonComments ){		// script has commands that are not comments
				thisCommand_obj.script.runEvent(0);
			}else{																	
				// if:  do not run this script because it will loop endlessly.  Instead ignore this loop and resume the parent script.
				prom.keep();
			}
		}// if:  condition is true
		else
		{// if:  condition is false
			// instantly done
			prom.keep();
		}// if:  condition is false
	}// if:  script has not been interrupted
	
	
	// wait for promise
	return prom;
	
	
	
	
	
	function getConditionResult( thisCommand_obj ){
		var data = thisCommand_obj.data;
		
		// resolve target variable
		// parse any embedded variable paths
		var target_str = nestedEval( data.condition[0], "RAM", "_this" );
		var target = evalPath( target_str, "RAM", "_this" );
		//var target = getImpliedValue( target );		// convert string to appropriate datatype if neccessary
		
		// resolve value
		var thisValue = getImpliedValue(data.condition[2]);		// convert string to appropriate datatype if neccessary
		
		// parse any embedded variable paths
		thisValue = nestedEval( thisValue, "RAM", "_this" );
		var value = getImpliedValue( thisValue );
		
		
		// test the condition
		var conditionResult = false;
		switch(data.condition[1])
		{
			case "=":
				var conditionResult = (target == value);
			break;
			case "!=":
				var conditionResult = (target != value);
			break;
			case ">":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target > value);
			break;
			case ">=":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target >= value);
			break;
			case "<":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target < value);
			break;
			case "<=":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target <= value);
			break;
		}// switch:  operator
		
	//	trace("\t condition:  "+data.condition[0]+" "+data.condition[1]+" "+data.condition[2]+"  ("+conditionResult+")");
		return conditionResult;
	}// getConditionResult()
	
	
}// define_while()